#include "af901x.h"
//#include "MT2060M.h"
#include "FS803A.h"

static int af901x_frontend_attach(struct dvb_usb_adapter *adap)
{
	adap->fe = af901x_attach(1);	

	return adap->fe == NULL ? -ENODEV : 0;
}

static int af901x_tuner_attach(struct dvb_usb_adapter *adap)
{
	//mt2060_attach(adap->fe);
	fs803_attach(adap->fe);
	return  0;
}

struct usb_device_id af901x_usb_id_table[] = {
		{ USB_DEVICE(0x0ccd,0x0069) },
		{ USB_DEVICE(0x0ccd,0x0068) },
		{ }		/* Terminating entry */
};
MODULE_DEVICE_TABLE(usb, af901x_usb_id_table);

struct dvb_usb_device_properties af901x_devices[] = {
	{
		.usb_ctrl          = DEVICE_SPECIFIC,
		.download_firmware = af901x_download_firmware,
		.no_reconnect      = 1,
		.size_of_priv      = sizeof(struct af901x_state),
		.power_ctrl		   = af901x_powerctrl,
		.identify_state    = af901x_identify_state,
		
		.num_adapters = 1,
		.adapter = {
			{
				.frontend_attach  = af901x_frontend_attach,
				.tuner_attach     = af901x_tuner_attach,
				.streaming_ctrl   = af901x_streaming_ctrl,
				.stream = { 
				.type = USB_BULK,
				.count = 4,
				.endpoint = 0x84,
				.u = {
					.bulk = {
						.buffersize = 96256,
						}
					}
				}
			},
		},

		.num_device_descs =1,
		.devices = {
			{   "Afatech USB2.0 DVB-T Recevier",
				{ &af901x_usb_id_table[0], &af901x_usb_id_table[1] },
				{ NULL },
			}
		}
	}
};

int af901x_device_count = ARRAY_SIZE(af901x_devices);
